function qu = t_inv(v,pr)
% T_INV Inverse cumulative t-probability distribution
%
%       QU = T_INV(V,PR)
%
%       Given values (0)PR(1) and V(>0), QU is the appertaining
%       quantile of a random t-distributed variate with V degrees 
%       of freedom. Thus, the t-variate is smaller/equal than QU
%       with probability PR.

%       R.Marbach,  Ver.1.0,  Mar.7,1990

if nargin~=2
  error('Wrong number of input arguments')
end

[m,n]=size(pr);
if (row(v)*col(v))==1, v=v*ones(m,n); end
if any(size(v)~=size(pr))
  error('Input arguments don''t match')
end

if any(v <= 0)
  error('parameter input range is: v > 0')
end

if any(pr < 0) | any(pr > 1)
  error('argument input range is: 0  pr  1')
end

qu=zeros(m,n);
indexreadyN = ~(pr == 0.5);
% if pr==0.5, then qu=0
if any(indexreadyN)
  index1  = indexreadyN & (pr < 0.5);
  if any(index1), pr(index1)=1-pr(index1); end
  a = 0.5*v;
  b = 0.5*ones(m,n);
  qu = sqrt(v./ betaiinv(a,b,2*(1-pr)) - v);
  if any(index1), qu(index1) =-qu(index1); end
end
