function pr = t(v,qu)
% T  Cumulative t-probability distribution
%
%    PR = T(V,QU)
%
%    PR is the probability for a random t-distributed variable
%    with V degrees of freedom to be smaller than (quantile) QU.

%    R.Marbach,  Ver.1.0,  Mar.6,1990

if nargin~=2
  error('Wrong number of input arguments')
end

[m,n]=size(qu);
if (row(v)*col(v))==1, v=v*ones(m,n); end
if any(size(v)~=size(qu))
  error('Input arguments don''t match')
end

a = 0.5*v;
b = 0.5*ones(m,n);
x = v./(v+qu.*qu);
pr = 1 - 0.5*beta(a,b,x);
