function [sitdatapersec,pds,pds01]=sit2pdsloopcenterbin2(sd,samplerate,windowtime,spec2avg,wave2avg)

%

%adjust the number of samples to process to be a multiple of 2
if rem(samplerate*windowtime,2)
    nsamp=samplerate*windowtime-1;
else
    nsamp=samplerate*windowtime;
end

% %adjust the addtional samples to process to be a multiple of 2.  Additional
% %samples are defined as 60% of the fundamental period (ie 1/f_fund). To
% %center the fund freq bin, the beginning of the sample block is stepped
% %from 1:2:1.2*fundperiod and the end is stepped from end - .6*fundperiod to
% %end + .6*fundperiod.  Adding 0.8*sample rate to the sample block ensures
% %the lowest frequency of 0.75Hz will be able to a + and - to the end of the
% %block
% 
% if rem(samplerate*.8,2) %see comment above for 0.8 value
%     nend=samplerate*.8+1;
% else
%     nend=samplerate*.8;
% end

nspec=floor(size(sd,1)/nsamp);
sitdatapersec(nspec)=struct();
pds=zeros(nspec,ceil(size(sd,2)/wave2avg));

for i=1:nspec
% for i=[1:22,22,24:55] %For Jake Day1, sitting 19
    % disp(i)
    [abs,stats,peakp]=centerbin2(sd((i-1)*nsamp+1:i*nsamp,:),samplerate,spec2avg,wave2avg);
    sitdatapersec(i).stats=stats;
    sitdatapersec(i).pds=pds;
    sitdatapersec(i).peakp=peakp;
    pds(i,:)=abs';
end
% i=56;
% [abs,stats,peakp]=centerbin(sd(end-nsamp-nend+1:end,:),nsamp,samplerate);
% sitdatapersec(i).stats=stats;
% sitdatapersec(i).pds=pds;
% sitdatapersec(i).peakp=peakp;
% pds(i,:)=abs';

pds01=pds-min(pds,[],2)*ones(1,size(pds,2));
pds01=pds01./(pds01(:,1)*ones(1,size(pds,2)));
