function [hr,rcal]=rba(ab,y,ntavg,npb)

%USAGE:  [hr,rcal]=rba(ab,y,ntavg,npb)
%
%Ab is the absorbance matrix of session averages (ie with replicas)
%
%y is the corresponding ysi vector
%
%ntave determines how many linear combos to average (usually 90)
%
%Output is such that the new ysi is a rectangular distribution with 10 bins between
%0 mg/dL and 400 mg/dL, each bin having a population of npb.

%npb=1000;
%ntavg=90;
i=[1:10;0:40:360;40:40:400];
%check to make sure max bins can be filled
if 2*max(y)-min(y)<max(i(2,:))
    i(:,i(2,:)>2*max(y)-min(y))=[];
    disp(['Max Bin Now ',int2str(i(2,end)),' to ',int2str(i(3,end))])
end
%check to make sure min bins can be filled
if 2*min(y)-max(y)>min(i(2,:))
    i(:,i(2,:)<2*min(y)-max(y))=[];
    disp(['Min Bin Now ',int2str(i(2,1)),' to ',int2str(i(3,1))])
end

sy=length(y);
rcal=[];

chunk=36000;
rand('seed',0);

for j=1:size(i,2)

    c=round(rand(chunk,3)*(sy-1))+1;
    c((c(:,1)==c(:,2))|(c(:,1)==c(:,3))|(c(:,2)==c(:,3)),:)=[];
    csize=size(c,1);

    yl=[];
    yl=y(c(:,1))+y(c(:,2))-y(c(:,3));

    c1=[];

    if j==1
        c1=[c1;c((yl>=i(2,j))&(yl<=i(3,j)),:)];
    else
        c1=[c1;c((yl>i(2,j))&(yl<=i(3,j)),:)];
    end

    while size(c1,1)<ntavg*npb
        c=round(rand(chunk,3)*(sy-1))+1;
        c((c(:,1)==c(:,2))|(c(:,1)==c(:,3))|(c(:,2)==c(:,3)),:)=[];
        csize=csize+size(c,1);

        yl=[];
        yl=y(c(:,1))+y(c(:,2))-y(c(:,3));

        if j==1
            c1=[c1;c((yl>=i(2,j))&(yl<=i(3,j)),:)];
        else
            c1=[c1;c((yl>i(2,j))&(yl<=i(3,j)),:)];
        end
    end

    k=1:ntavg*npb;
    rcal=[rcal;avp([[y(c1(k,1),:)+y(c1(k,2),:)-y(c1(k,3),:)],[ab(c1(k,1),:)+ab(c1(k,2),:)-ab(c1(k,3),:)]],ntavg)];
    disp(['Bin Number ',int2str(j),' required ',int2str(csize),' linear combinations.']);

end

hr=rcal(:,1);
rcal(:,1)=[];