function b = plssolv(x,y,useR)
%PLSSOLV regression vector of PLS-inversion with MEAN-CENTERED data.
%
%             B = PLSSOLV(X,Y,useR)
%
%       The linear equation system
%                Y-mean(Y) = ( X-ones(row(X),1)*mean(X) ) * B + E 
%       is solved for regression vector B by inverting X with a number of
%       useR PLS-ranks (if the stopping criteria in subroutine LANBI permit
%       bidiagonalization up to rank useR).
%       Only the PLS1 algorithm is implemented, so Y has to be a vector.

%       R. Marbach,  Ver.1.0,  Jan.23,1992

% bi-diagonalization
[u,bi,w] = lanbi(x-ones(row(x),1)*mean(x), y-mean(y), useR);
% inversion
b = w * inv(bi) * u'* y;
