function [y_new,b] = plspred(x,y,x_new,useR);
%PLSPRED  prediction by PLS regression using averaged data.
%
%         Ynew = PLSPRED(X, Y, Xnew) or
%         Ynew = PLSPRED(X, Y, Xnew, useR)
%
%         After having computed the PLS regression of either maximal rank or
%         rank = 'useR' (if specified and permitted by the stopping criteria;
%         regressor matrix X and regressand vector Y will be mean-centered!);
%         a prediction is applied to the new datum Xnew. Xnew may be a matrix
%         containing new spectra in either its rows or columns.
%         By invoking ..
%
%         [Ynew, B] = PLSPRED(X, Y, Xnew) or
%         [Ynew, B] = PLSPRED(X, Y, Xnew, useR)
%
%         the PLS regression coefficients (for mean-centered data!) will be
%         returned as well.

% R. Marbach, Aug.13'th, 1991

if     (nargin~=3)  & (nargin~=4)
  error('Wrong number of input arguments')
%elseif (nargout~=1) & (nargout~=2)
%  error('Wrong number of output arguments')
end

av_x = mean(x);
av_y = mean(y);
% PLS regression
if nargin==3
  b = plsinv( x - ones(row(x),1)*av_x, y - av_y)*(y - av_y);
else
  b = plsinv( x - ones(row(x),1)*av_x, y - av_y, useR)*(y - av_y);
end
% PLS prediction

if 1==2
if row(x_new)==col(x_new)
  error('Quadratic matrix Xnew: Spectra as columns or rows?')
elseif row(x_new)==col(x)
  x_new = x_new';
end
end

b=b(:);
y_new = av_y + (x_new - ones(row(x_new),1)*av_x)*b;

%if nargout==1
%  yo=y_new;
%else
%  yo=y_new;
%  bo=b(:);
%end
