function xi = plsinv(x,y,useR)
%PLSINV  Partial least-squares generalized ('biased') inverse.
%
%             XI = PLSINV(X,Y)
%
%        provides the PLS inverse XI of X of maximum rank. 
%        PLSINV uses LANBI (cf. for stopping criteria used).
%
%        Unit-length scaled vector X'Y is used as Lanczos start vector.
%        Since only the PLS1 algorithm is implemented, Y has to be a vector!
%
%             XI = PLSINV(X,Y,useR)
%
%        provides PLS inverse of rank useR (if the criteria permit).

%        R. Marbach,  Ver.1.0,  Mar.21,1990

if (nargin~=2) & (nargin~=3)
  error('Wrong number of input arguments')
end
if nargout~=1
  error('Wrong number of output arguments')
end

% PLS-inverse
if nargin==3
  [u,b,w]=lanbi(x,y,useR);
else
  [u,b,w]=lanbi(x,y);
end
xi=w*inv(b)*u';
