function s=mysvd(x, f, uax, ucom, vax, vcom, p);
% MYSVD plots results of SVD decomposition
%
%       S=MYSVD(X,F,UAX,UCOM,VAX,VCOM,P)
%
%       Mean-centers X, calls Matlab's SVD, and plots U-,S-,V-results. S can also be returned.
%       X      matrix: data
%       F      integer: # of first figure results are printed into
%       UAX    vector: defines x-axis of u-plots
%       UCOM   vector: plotted autoscaled into u-plots for comparison purposes (UCOM=0 -> no plot)
%       VAX    vector: defines x-axis of v-plots
%       VCOM   vector: plotted autoscaled into v-plots for comparison purposes (VCOM=0 -> no plot)
%       P      scalar: P=0 no hardcopy print, P=1 hardcopy print

% R.M. 22 July 97

[u,s,v]=svd(x-ones(row(x),1)*mean(x));
figure(f)
semilogy(diag(s),'o'), grid, pause

for r=1:min([row(x),col(x)])
 figure(f+r)
 subplot(211)
 plot(uax, u(:,r))
 if any(ucom~=0), plotase(uax,ucom,'r:'), end
 %ax=axis; set(gca,'XTick', [170*floor(ax(1)/170):170:2040])
 % ax=axis; set(gca,'XTick', [85:85:986])
 % ax=axis; set(gca,'XTick',12*floor(ax(1)/12):12:12*ceil(ax(2)/12))
 r2=corrcoef(u(:,r), ucom);
 str=['U(:,',int2str(r),')','     r=',num2str(r2(1,2))]; title(str), grid
 % xlabel('1997hours')

 subplot(212)
 plot(vax, v(:,r))
 if any(vcom~=0), plotase(vax, vcom,'--'), end
 % load user\glucnorr
 % plotase(nm_norr, glucnorr,'r')
 strich([1211.1 1475.6 1574.2 1696 1767 1937.3], -0.05, 0.05)
 strich([1720 1765],-0.03, 0.03,'g--')
 str=['V(:,',int2str(r),')']; title(str), grid
 pause
 if p==1, print, end
end