function [q,q1,q2,std1,std2]=myanova(x,ng);
% MYANOVA Single-factor variance analysis
%
%         [q1,q2,std1,std2]=myanova(x,ng);
%
%         ng=number of rows in x that go into one group. Thus, x contains n
%         oberservations in n/ng groups.

% R.M. 1/7/98

[n,m]=size(x);
r=n/ng; % # of groups
%if ~isint(r), exit('something''s fishy.'), end

xavg =mean(x);
xavgr=avp(x,ng);

q1=ng*sum((xavgr - ones(r,1)*xavg).^2);
q=sum( (x - ones(n,1)*xavg).^2 );
q2=q-q1;

std1=sqrt(q1/(r-1));
std2=sqrt(q2/(n-r));