function [mbr2bbcr,ysipreds,bvects]=jpredsic(xcal,ycal,avgcal,xval,yval,avgval)

%function [mbr2bbcr,ysipreds,rms]=jpred(xcal,ycal,avgcal,xval,yval,avgval)
%function that returns the slope intercept R^2 bias values for the
%least squares fit on D-1000 predictions vs. YSI values for all 64
%ranks and the rms (using PLSVAL) and the bias corrected rms value (between the 
%ysi's and the lsfit to the predicted values).
%Bias is defined as (average d-1000 values) - (average yval).
%The output mbr2bbcr is a matrix with 1st column being slope, 2nd column
%being intercept the 3rd column being R^2 values the 4th column being
%and 5th column being the bias corrected rms.  Each column is a vector
%with each element corresponding to the rank equal to the vector index.
%ysipreds is a mx65 matrix with each column being the d-1000 ysi predictions
% for the rank equal to the column index and the 65th column being yval.
%xcal is the absorbance spectrum for the calibration day. ycal is the interpolated
%YSI's for the calibration day. xval is the absorbance spectrum for the validation
%day. yval is the interpolated YSI's for the  validation day and is used only for the
%least squares fitting. avgcal is the number of spectra to average for the calibration
%day and avgval is the number of spectra to average for the validation day.
%The algorithm below is based on PLSPRED and PLSINV

[mj1,mj2,mj3]=jpred(xcal,ycal,1,xcal,ycal,1);

for i=1:size(xcal,2)
   mj1(i,1)=orthslope(ycal,mj2(:,i));%replace plain pls slope with orth slope
end


%average the absorbance matricies and Ysi values.
if avgcal>1
xcal=avp(xcal,avgcal);
ycal=avp(ycal,avgcal);
end

if avgval>1
xval=avp(xval,avgval);
yval=avp(yval,avgval);
end


%calculate the SEP (rms values in mg/dL) using PLSVAL
%rms=plsval(xcal,ycal,xval,yval);

%find the number of spectra in the absorbance spectra.
[m1,n1]=size(xcal);
[m2,n2]=size(xval);
[l,l1]=size(yval);

xavg=mean(xcal);
yavg=mean(ycal);

%set the last column of ysipreds to the actual ysi's
ysipreds(:,n1+1)=yval;

%calculate the predicted values for the all ranks
%from last rank prediction
[u,b1,w]=lanbi(xcal-ones(m1,1)*xavg,ycal-yavg,n1);
h=size(b1,2);

for i=1:n1
%safeguard for lanbi output smaller than 64 ranks
if i>h
  b=w(:,1:h)*inv(b1(1:h,1:h))*u(:,1:h)'*(ycal-yavg);
else
   b=w(:,1:i)*inv(b1(1:i,1:i))*u(:,1:i)'*(ycal-yavg);
end

b=b(:);
bvects(:,i)=b./mj1(i,1);
   ypred=yavg+(xval-ones(m2,1)*xavg)*(b/mj1(i,1));%1.25 to get from .8 to 1
   
   %determine the slope and intercept for d-1000's predictions vs ysi's
   %for the ith rank
   p=polyfit(yval,ypred,1);
   mbr2bbcr(i,1)=p(1);
   mbr2bbcr(i,2)=p(2);
   
   %determine the R^2 value for the above least squares fit
   c=corrcoef(yval,ypred).^2;
   mbr2bbcr(i,3)=c(1,2);
   
   %determine the bias value
   mbr2bbcr(i,4)=mean(ypred)-mean(yval);
   
   %determine the bias/slope corrected value rms between LS fit to ypred vs. ysi and
   %ysi values
   
   mbr2bbcr(i,5)=sqrt(sum((ypred-polyval(p,yval)).^2)/l);
   
   %determine the bias only corrected value for predicted values.
   
   mbr2bbcr(i,6)=sqrt(sum((yval-ypred+mbr2bbcr(i,4)).^2)/l);
   
   %determine the SEP
   
   mbr2bbcr(i,7)=sqrt(sum((yval-ypred).^2)/l);
   
   %write the predicted values to the ith column of the output
   %matrix for the ith rank
   ysipreds(:,i)=ypred;
end
