function [f,p,p1]=jfft(x,ts)
%[f,p,p1]=jfft(x,ts)
%computes amplitude spectrum, p (power spectrum is p^2), of x using ts as the time or pixel
%space between samples and returns the frequency vector f for plotting. p1
%is the FFT returned value of the 0 frequency since the 

%Concepts below taken from NI App Note 041
% fftsize=2^nextpow2(length(x));%uses the next power of 2 for length of fft.
% %This allow s the FFT computation to be a power of 2 for speed

%use actual number of points for simplicityf
fftsize=length(x);

%if actual number of points is not even, ignore last sample
if mod(fftsize,2)~=0
    x=x(1:end-1);
    fftsize=fftsize-1;
end
fftx=fft(x,fftsize)/length(x);%computes fft and scales for number of points

% p=real(fftx.*conj(fftx));%computes power.  similar to abs(fftx).^2. real
% %call is just for MATLAB coder (doesn't know fft.*conj(fft) is always real

%use abs(fft) for simplicity of getting amplitude
p=abs(fftx);
p(2:end)=2*p(2:end);%scale p (which in this case is amplitude) by 2 because 
%the mirrored half of fft spectrum has half of the signal (not DC ... and
%not nyquist ... ).

f=[0:fftsize/2-1]'/fftsize/ts;%computes frequency
p=p(1:fftsize/2);%removes mirrored values
f=f(:);%helps MATLAB coder know the output is a column vector
p=p(:);%helps MATLAB coder know the output is a column vector

%p=sqrt(p);%converts to amplitude ... should really call this a instead of p
%sqrt only needed for converting power spectrum to amplitude

p1=p(1);

p=p/p1;%this step normalizes the fft to the DC value (useful when evaluating
%a transfer function such as MTF



% %[f,p]=jfft(x,ts)
% %computes power spectrum, p, of x using ts as the time space between samples
% %and returns the frequency vector f for plotting
% 
% fftsize=2^nextpow2(length(x));%uses the next power of 2 for length of fft
% %fftsize=length(x);
% fftx=fft(x,fftsize)/length(x);%computes fft and scales for number of points
% %fftx=fft(x);%computes fft and scales for number of points
% p=fftx.*conj(fftx);%computes power.  similar to abs(fftx).^2
% f=[0:fftsize/2-1]'/fftsize/ts/2;%computes frequency
% p=p(1:fftsize/2)*2;%removes mirrored values and scales for removal of half the data
% p=sqrt(p);
% p1=p(1);
% p=p/p1;
% 


