function y=gammacln(x)
%GAMMACLN  returns natural logarithm of complete gamma function.
%
%          Y = GAMMACLN(X)
%
%          MATLAB's function file GAMMAC.M for computing the complete gamma
%          function causes a machine overflow when being invoked with input
%          argument  171.4584 (e.g., gammac(172)=inf).
%
%          GAMMACLN avoids overflow problems by using an approximative
%          series expansion of log(gammac(x)) for x > 10 (see code below).
%          Input argument X might be a matrix.
%
%          R.Marbach, Dec.4, 1991

% input arguments are worked upon element-wisely
y = x;
for i=1:prod(size(x))
  if x(i) < 10
      y(i) = log(gammac(x(i)));
  else
      %
      % see W.H.Press et al., 'Numerical Recipes',
      %     Cambridge University Press 1986, 157 (FORTRAN) or 704 (PASCAL)
      %
      stp=2.50662827465;
      fpf=5.5;
      cof=[ 76.18009173
           -86.50532033
            24.01409822
           -1.231739516
            0.120858003e-2
           -0.536382e-5    ];
      %
      % notation: xx -> x(i)
      %           x  -> xx
      xx=x(i)-1;
      tmp=xx+fpf;
      tmp=(xx+0.5)*log(tmp) - tmp;
      ser=1;
      for j=1:6
        xx  = xx + 1;
        ser = ser + cof(j)/xx;
      end
      y(i) = tmp + log(stp*ser);
  end
end
