function [pds,stats,peakp]=centerbin2(sd,samplerate,spec2avg,wave2avg)

sd=avp(sd,spec2avg);
samplerate=samplerate/spec2avg;
sd=avp(sd',wave2avg)';
usechan=floor(18/wave2avg);

nsamp=size(sd,1);
%adjust the number of samples to process to be a multiple of 2
if rem(nsamp,2)
    nsamp=nsamp-1;
end

startfreqind=ceil((.75*nsamp/samplerate)+1);
initialfft=fft(sd(1:nsamp,usechan));%channel 18 is a high DC signal channel.  
%it is not the highest signal channel, and it is not the highest AC signal
%channel.  Highest DC is between 18 and 20. Highest AC is 10.
fundind=find(abs(initialfft(1:end/2))==max(abs(initialfft(startfreqind:end/2))));
stats.initialfreq=fundind/nsamp*samplerate;%this is fundamental freq in Hz
stats.initialamp=abs(initialfft(fundind))/nsamp*2;%Amp at fund freq in V/rthz
stats.initialphase=angle(initialfft(fundind));%Phase of fund freq in radians
stats.initialperiod=1/stats.initialfreq;%Fund cycle time (pulse duration) in Sec

%determine number of samples in cycle to be used as the length of samples
%at the start/end of the time window (scaled to 120% of the cycle samples)
%The all combinations of start:2:start + this value and
% end:-2:end- this value will be used to find the optimal start end indices
% to produce the highest fundamental freqeuncy amplitude.  This should
% result is the most centered frequency bin for the fundamental pulse
% frequency in the data set

nend=ceil(samplerate*stats.initialperiod*1.2)-rem(ceil(samplerate*stats.initialperiod*1.2),4);

peakp=zeros((nend/2)^2,5);
for ii=2:2:nend
    for jj=2:2:nend
        ftids=(1+(ii-2)):nsamp-nend+(jj-2);
        ftlength=length(ftids);
        ftstartfreqind=ceil((.75*ftlength/samplerate)+1);
        ft=abs(fft(sd(ftids,usechan)));
        ftfundind=find(ft(1:end/2)==max(ft(ftstartfreqind:end/2)));
        peakp((ii/2-1)*nend/2+jj/2,:)=[ii-2,jj-2,(ftfundind-1)/ftlength*samplerate,ft(ftfundind)/ftlength*2,ftfundind];
    end
end

peakind=find(peakp(:,4)==max(peakp(:,4)));%max fund freq amplitude found after bin centering
startind=peakp(peakind,1)+1;%first row to use in the data set
stopind=peakp(peakind,2)+nsamp-nend;%last row to use in the data set
fundfreq=peakp(peakind,3);%bin centered fund freq
fundamp=peakp(peakind,4);%bin centered fund freq amplitude
ftfundid=peakp(peakind,5);%element of the fft the fund freq occurs
stats.maxfreq=max(peakp(:,3));%max value of fund freq found during bin centering
stats.minfreq=min(peakp(:,3));%min value of fund freq found during bin centering
stats.minamp=min(peakp(:,4));%min fund freq amp found during bin centering
winsamps=length(startind:stopind);%number of row of the data set used
wintime=winsamps/samplerate;%actual time represented by winsamps
winpulses=wintime*fundfreq;%estimated number of pulse cycles found in wintime

ftall=fft(sd(startind:+stopind,:));%bin centered fft
phangles=angle(ftall(ftfundid,:));%phase angles for each pixel after bin centering
amps=abs(ftall(ftfundid,:))/winsamps*2*1.2;%1.2 is empirical to get fund
%amplitude to be peak2peak of signal
dc=abs(ftall(1,:))/winsamps;
pds=log10((dc+amps)./(dc-amps));

stats.peakind=peakind;
stats.startind=startind;
stats.stopind=stopind;
stats.fundfreq=fundfreq;
stats.fundamp=fundamp;
stats.ftfundid=ftfundid;
stats.winsamps=winsamps;
stats.wintime=wintime;
stats.winpulses=winpulses;
stats.phangles=phangles;
stats.amps=amps;
stats.dc=dc;
stats.nend=nend;
