function [ysipreds,bvects]=jpred1(xcal,ycal,xval,yval)

%find the number of spectra in the absorbance spectra.
[m1,n1]=size(xcal);

xavg=mean(xcal);
yavg=mean(ycal);

%set the last row of ysipreds to the actual ysi
ysipreds(n1+1,:)=[yval,0];

%calculate the predicted values for the all ranks
%from last rank prediction
[u,b1,w]=lanbi(xcal-ones(m1,1)*xavg,ycal-yavg,n1);
h=size(b1,2);

for i=1:n1
%safeguard for lanbi output smaller than 64 ranks
if i>h
  b=w(:,1:h)*inv(b1(1:h,1:h))*u(:,1:h)'*(ycal-yavg);
else
   b=w(:,1:i)*inv(b1(1:i,1:i))*u(:,1:i)'*(ycal-yavg);
end

b=b(:);
bvects(:,i)=b;
   ypred=yavg+(xval-xavg)*b;
   
   
   %determine the error
   ysipreds(i,2)=ypred-yval;
   
   %write the predicted value to the ith row of the output
   %matrix for the ith rank
   ysipreds(i,1)=ypred;
end
